/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.impl;

import ec.gob.sri.anexo.prepersistencia.modelo.RigTmpArchivoDetalle;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.persistencia.AdministradorModelo;
import ec.gob.sri.dimm.api.modelo.validacion.MensajeValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.excepciones.ExcepcionContribuyenteNoEncontrado;
import ec.gob.sri.dimm.ats.modelo.impl.ContenedorObjetosImportacion;
import ec.gob.sri.dimm.ats.modelo.obj.ComprobanteAnulado;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.compras.TransaccionCompra;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.Exportacion;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.Beneficiario;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.BeneficioRetencion;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.Fideicomiso;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Recap;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.ComprobanteRendimiento;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.Rendimiento;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Comprador;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.ComprobanteVenta;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Establecimiento;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Venta;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import ec.gov.sri.dimm.principal.factory.BeanFactory;
import ec.gov.sri.dimm.principal.persistencia.Contribuyente;
import ec.gov.sri.dimm.principal.servicios.ServicioContribuyente;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdministradorModeloATS
extends AdministradorModelo<Iva> {
    public Document exportar(Iva modelo) {
        Document documento = this.obtenerDoc();
        modelo.exportar(documento, null);
        return documento;
    }

    public Iva importar(Document documento) {
        Iva modeloIva = new Iva();
        this.importarCabecera(documento, modeloIva);
        modeloIva.inicializar();
        this.buscarContribuyenteRegistradoEnLaBaseLocalDelDimm(modeloIva);
        this.importarCompras(documento, modeloIva);
        this.importarVentas(documento, modeloIva);
        this.importarVentasEstablecimiento(documento, modeloIva);
        this.importarFideicomisos(documento, modeloIva);
        this.importarAnulados(documento, modeloIva);
        this.importarExportaciones(documento, modeloIva);
        this.importarRecaps(documento, modeloIva);
        this.importarRendimientosFinancieros(documento, modeloIva);
        return modeloIva;
    }

    private void importarCabecera(Document documento, Iva modeloIva) {
        String[] etiqCabecera;
        HashMap<String, Element> mapaTemp = new HashMap<String, Element>();
        String[] stringArray = etiqCabecera = new String[]{"TipoIDInformante", "IdInformante", "razonSocial", "Anio", "Mes", "regimenMicroempresa", "numEstabRuc", "totalVentas", "codigoOperativo"};
        int n = etiqCabecera.length;
        int n2 = 0;
        while (n2 < n) {
            String etiqueta = stringArray[n2];
            NodeList nl = documento.getElementsByTagName(etiqueta);
            Element eDato = (Element)nl.item(0);
            if (eDato != null) {
                mapaTemp.put(etiqueta, eDato);
            }
            ++n2;
        }
        modeloIva.importar(null, mapaTemp);
    }

    private void buscarContribuyenteRegistradoEnLaBaseLocalDelDimm(Iva modeloIva) {
        ServicioContribuyente servicio = (ServicioContribuyente)BeanFactory.getBean((String)"servicioContribuyente");
        Contribuyente contribuyente = servicio.findByRuc(modeloIva.getIdentificacion());
        if (contribuyente == null) {
            throw new ExcepcionContribuyenteNoEncontrado("El contribuyente con RUC " + modeloIva.getIdentificacion() + " no esta registrado en la base local del DIMM");
        }
    }

    private void importarCompras(Document documento, Iva modeloIva) {
        NodeList nl = documento.getElementsByTagName("detalleCompras");
        int i = 0;
        while (i < nl.getLength()) {
            Node nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                TransaccionCompra transaccionCompra = new TransaccionCompra();
                transaccionCompra.setPropietario(modeloIva);
                transaccionCompra.importar(elem, null);
                modeloIva.agregarTransaccionCompra(transaccionCompra);
            }
            ++i;
        }
    }

    private void importarVentas(Document documento, Iva modeloIva) {
        NodeList ventas = documento.getElementsByTagName("detalleVentas");
        ContenedorObjetosImportacion.mapaClientesVenta.clear();
        int i = 0;
        while (i < ventas.getLength()) {
            Node nodo = ventas.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                Comprador comprador = new Comprador();
                comprador.importar(elem, null);
                Venta venta = this.obtenerVentaExistenteAsociadaAlComprador(comprador);
                if (venta == null) {
                    venta = new Venta();
                    venta.setComprador(comprador);
                    comprador.setPropietario((ObjetoModelo)venta);
                    venta.setPropietario(modeloIva);
                    this.agregarVentaAsociadaAlComprador(venta, comprador);
                }
                ComprobanteVenta comprobante = new ComprobanteVenta();
                comprobante.importar(elem, null);
                comprobante.calcularTotalComprobante();
                venta.agregarComprobantesVenta(comprobante);
                venta.calcularTotalVentaPorCliente();
                venta.calcularTotalCompensacionesPorCliente();
            }
            ++i;
        }
        for (Map.Entry<String, ObjetoModelo> entry : ContenedorObjetosImportacion.mapaClientesVenta.entrySet()) {
            modeloIva.agregarClienteVenta((Venta)entry.getValue());
        }
        modeloIva.actualizarTotalVentas();
    }

    private void agregarVentaAsociadaAlComprador(Venta venta, Comprador comprador) {
        ContenedorObjetosImportacion.mapaClientesVenta.put(this.generarClaveCliente(comprador), (ObjetoModelo)venta);
    }

    private Venta obtenerVentaExistenteAsociadaAlComprador(Comprador comprador) {
        return (Venta)ContenedorObjetosImportacion.mapaClientesVenta.get(this.generarClaveCliente(comprador));
    }

    private void importarVentasEstablecimiento(Document documento, Iva modeloIva) {
        NodeList nl = documento.getElementsByTagName("ventaEst");
        int i = 0;
        while (i < nl.getLength()) {
            Node nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                Establecimiento establecimiento = new Establecimiento();
                establecimiento.importar(elem, null);
                modeloIva.agregarEstablecimiento(establecimiento);
            }
            ++i;
        }
    }

    private void importarFideicomisos(Document documento, Iva modeloIva) {
        NodeList nodosDetalleFideicomisos = documento.getElementsByTagName("detalleFideicomisos");
        ContenedorObjetosImportacion.mapaFideicomisos.clear();
        int i = 0;
        while (i < nodosDetalleFideicomisos.getLength()) {
            Node detalleFideicomiso = nodosDetalleFideicomisos.item(i);
            if (detalleFideicomiso.getNodeType() == 1) {
                Element elem = (Element)detalleFideicomiso;
                List<Fideicomiso> fideicomisosAsociados = this.obtenerFideicomisosAsociadosAlBeneficiario(elem, modeloIva);
                for (Fideicomiso fideicomiso : fideicomisosAsociados) {
                    if (!this.obtenerFideicomisoSiExistePreviamente(fideicomiso)) {
                        this.agregarFideicomisoAMapaDeExistentes(fideicomiso);
                    } else {
                        fideicomiso = (Fideicomiso)ContenedorObjetosImportacion.mapaFideicomisos.get(this.generarClaveFideicomiso(fideicomiso));
                    }
                    this.agregarBeneficioAlFideicomiso(elem, fideicomiso);
                }
            }
            ++i;
        }
        for (Map.Entry<String, ObjetoModelo> entry : ContenedorObjetosImportacion.mapaFideicomisos.entrySet()) {
            modeloIva.agregarAdministradorFondos((Fideicomiso)entry.getValue());
        }
    }

    private void agregarFideicomisoAMapaDeExistentes(Fideicomiso fideicomisoExistente) {
        ContenedorObjetosImportacion.mapaFideicomisos.put(this.generarClaveFideicomiso(fideicomisoExistente), (ObjetoModelo)fideicomisoExistente);
    }

    private boolean obtenerFideicomisoSiExistePreviamente(Fideicomiso fideicomiso) {
        return ContenedorObjetosImportacion.mapaFideicomisos.get(this.generarClaveFideicomiso(fideicomiso)) != null;
    }

    private void importarRendimientosFinancieros(Document documento, Iva modeloIva) {
        NodeList nl = documento.getElementsByTagName("detalleRendFinancieros");
        int i = 0;
        while (i < nl.getLength()) {
            Node nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                Rendimiento rendimiento = new Rendimiento();
                rendimiento.setPropietario(modeloIva);
                rendimiento.importar(elem, null);
                modeloIva.agregarRendimiento(rendimiento);
            }
            ++i;
        }
    }

    private void importarRecaps(Document documento, Iva modeloIva) {
        NodeList nl = documento.getElementsByTagName("detalleRecap");
        int i = 0;
        while (i < nl.getLength()) {
            Node nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                Recap recap = new Recap();
                recap.setPropietario(modeloIva);
                recap.importar(elem, null);
                modeloIva.agregarRecap(recap);
            }
            ++i;
        }
    }

    private void importarExportaciones(Document documento, Iva modeloIva) {
        NodeList nl = documento.getElementsByTagName("detalleExportaciones");
        int i = 0;
        while (i < nl.getLength()) {
            Node nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                Exportacion exportacion = new Exportacion();
                exportacion.setPropietario(modeloIva);
                exportacion.importar(elem, null);
                modeloIva.agregarExportacion(exportacion);
            }
            ++i;
        }
    }

    private void importarAnulados(Document documento, Iva modeloIva) {
        NodeList nl = documento.getElementsByTagName("detalleAnulados");
        int i = 0;
        while (i < nl.getLength()) {
            Node nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                ComprobanteAnulado comprobanteAnulado = new ComprobanteAnulado();
                comprobanteAnulado.importar(elem, null);
                modeloIva.agregarComprobanteAnulado(comprobanteAnulado);
            }
            ++i;
        }
    }

    private String generarClaveCliente(Comprador cliente) {
        return cliente.getTipoIdentificacion() + cliente.getIdentificacion();
    }

    private String generarClaveFideicomiso(Fideicomiso fideicomiso) {
        return fideicomiso.getTipoFideicomiso() + fideicomiso.getRucFideicomiso();
    }

    private List<Fideicomiso> obtenerFideicomisosAsociadosAlBeneficiario(Element elemento, Iva iva) {
        ArrayList<Fideicomiso> fideicomisos = new ArrayList<Fideicomiso>();
        NodeList detallesFValor = elemento.getElementsByTagName("detallefValor");
        int i = 0;
        while (i < detallesFValor.getLength()) {
            Fideicomiso fideicomiso = new Fideicomiso();
            fideicomiso.setPropietario(iva);
            NodeList valorList = elemento.getElementsByTagName("rucFideicomiso");
            Element eValor = (Element)valorList.item(0);
            fideicomiso.setRucFideicomiso(eValor.getTextContent());
            Node nodo = detallesFValor.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                valorList = elem.getElementsByTagName("tipoFideicomiso");
                eValor = (Element)valorList.item(0);
                int fideiComisoEntero = Integer.parseInt(eValor.getTextContent().trim());
                fideicomiso.setTipoFideicomiso(String.valueOf(fideiComisoEntero));
                fideicomiso.setDescripcionTipoFideicomiso(String.valueOf(fideicomiso.getTipoFideicomiso()) + "-" + UtilCatalogosATS.obtenerNombreDetalleCatalogo((String)"TIPOFIDE", (String)fideicomiso.getTipoFideicomiso()));
                valorList = elem.getElementsByTagName("totalF");
                eValor = (Element)valorList.item(0);
                fideicomiso.setMontoBeneficioTotal(eValor.getTextContent().trim());
                fideicomisos.add(fideicomiso);
            }
            ++i;
        }
        return fideicomisos;
    }

    private Fideicomiso agregarBeneficioAlFideicomiso(Element elemento, Fideicomiso fideicomiso) {
        NodeList nl = elemento.getElementsByTagName("detallefValor");
        int i = 0;
        while (i < nl.getLength()) {
            Element elem;
            NodeList valorList;
            Element eValor;
            String tipoFideicomiso;
            Node nodo = nl.item(i);
            if (nodo.getNodeType() == 1 && (tipoFideicomiso = String.valueOf(Integer.parseInt((eValor = (Element)(valorList = (elem = (Element)nodo).getElementsByTagName("tipoFideicomiso")).item(0)).getTextContent()))).equals(fideicomiso.getTipoFideicomiso())) {
                valorList = elem.getElementsByTagName("totalF");
                eValor = (Element)valorList.item(0);
                BeneficioRetencion beneficioRetencion = new BeneficioRetencion();
                beneficioRetencion.setPropietario((ObjetoModelo)fideicomiso);
                beneficioRetencion.setBeneficiario((Beneficiario)((Object)beneficioRetencion.getBeneficiario().importar(elemento, null)));
                beneficioRetencion.importar(elem, null);
                fideicomiso.agregarBeneficioRetencion(beneficioRetencion);
            }
            ++i;
        }
        return fideicomiso;
    }

    public ResultadoValidacion validarAnexo(Iva modelo) {
        ResultadoValidacion rv = new ResultadoValidacion();
        for (Rendimiento rend : modelo.getRendimientos()) {
            for (ComprobanteRendimiento comp : rend.getComprobantesRetencion()) {
                if (!comp.getDetallesAirRendimientos().isEmpty()) continue;
                rv.agregarMensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "RENDIMIENTOS FINANCIEROS\n Para el sujeto retenido " + rend.getRetenido().getIdentificacion() + " el Comprobante " + comp.getSerial() + " no posee conceptos de retenci\u00f3n");
            }
        }
        return rv.completarValidacionVariosMensajes();
    }

    public Hashtable<String, Hashtable<String, List<RigTmpArchivoDetalle>>> obtenerDatosValidacion(Iva modelo) {
        return null;
    }

    private Document obtenerDoc() {
        Document document = null;
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            document = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return document;
    }
}

